import { world, BlockTypes, BlockPermutation } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:araucaria_fence_gate', {
        onPlayerInteract(e) {
            const { block, player, face } = e
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            if (selectedItem && face === 'Up' && BlockTypes.get(selectedItem.typeId)) {
                const aboveBlock = block.above()
                if (aboveBlock.typeId === 'v360:araucaria_fence_gate') {
                    aboveBlock.setType(selectedItem.typeId)
                    if (player.getGameMode() !== "creative") {
                        if (selectedItem.amount > 1) {
                            selectedItem.amount -= 1
                            equipment.setEquipment('Mainhand', selectedItem)
                        } else {
                            equipment.setEquipment('Mainhand', undefined)
                        }
                    }
                    return
                }
            }
            const currentState = block.permutation.getState('v360:open')
            const newOpenState = !currentState
            const sound = newOpenState ? 'open.fence_gate' : 'close.fence_gate'
            const rotationAngle = player.getRotation().y
            const newCardinalDirection = getNewCardinalDirection(block.permutation.getState('minecraft:cardinal_direction'), rotationAngle)
            const newPermutation = BlockPermutation.resolve(block.typeId, {
                ...block.permutation.getAllStates(),
                'v360:open': newOpenState,
                'minecraft:cardinal_direction': newCardinalDirection
            })
            block.setPermutation(newPermutation)
            block.dimension.playSound(sound, block.location)
            const aboveBlock = block.above()
            if (aboveBlock.typeId === 'v360:araucaria_fence_gate' && aboveBlock.permutation.getState('v360:invisible')) {
                const aboveCurrentState = aboveBlock.permutation.getState('v360:open')
                if (aboveCurrentState !== newOpenState) {
                    const newAbovePermutation = BlockPermutation.resolve(aboveBlock.typeId, {
                        ...aboveBlock.permutation.getAllStates(),
                        'v360:open': newOpenState
                    });
                    aboveBlock.setPermutation(newAbovePermutation)
                }
            }
        },
        onPlayerDestroy(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (aboveBlock.typeId === 'v360:araucaria_fence_gate' && aboveBlock.permutation.getState('v360:invisible')) {
                aboveBlock.setType('minecraft:air')
            }
        },
        onPlace(e) {
            const { block } = e
            const aboveBlock = block.above()
            const currentStates = block.permutation.getAllStates()
            const cardinalDirection = currentStates['minecraft:cardinal_direction']
            if (cardinalDirection === 'south') {
                const newDirection = true
                currentStates['v360:direction'] = newDirection
                const newPermutation = BlockPermutation.resolve(block.typeId, currentStates)
                block.setPermutation(newPermutation);
            }
            if (aboveBlock.typeId === 'minecraft:air') {
                const newAboveStates = { ...currentStates }
                if (cardinalDirection === 'south') {
                    delete newAboveStates['minecraft:cardinal_direction']
                }
                newAboveStates['v360:invisible'] = true
                aboveBlock.setPermutation(BlockPermutation.resolve('v360:araucaria_fence_gate', newAboveStates))
            }
        },
        onTick(e) {
            const { block } = e;
            const { x, y, z } = block.location;
            const blockKey = `${x},${y},${z}`;
            const currentState = block.permutation.getState('v360:open')
            const cardinalDirection = block.permutation.getState('minecraft:cardinal_direction')
            const sound = currentState ? 'open.fence_gate' : 'close.fence_gate'
            const adjacentBlocks = {
                north: block.north(),
                east: block.east(),
                south: block.south(),
                west: block.west(),
                above: block.above(),
                below: block.below()
            }
            const allowedBlocks = [block.typeId.includes('wall')]
            const hasAllowedBlock = (blocks) => blocks.some(adjacentBlock => allowedBlocks.includes(adjacentBlock?.typeId))
            const hasAllowedAdjacentBlock = (cardinalDirection === 'north' || cardinalDirection === 'south')
                ? hasAllowedBlock([adjacentBlocks.east, adjacentBlocks.west])
                : hasAllowedBlock([adjacentBlocks.north, adjacentBlocks.south])
            block.setPermutation(block.permutation.withState('v360:in_wall_bit', hasAllowedAdjacentBlock))
            const excludedBlocks = [
                block.typeId.includes('door'), block.typeId.includes('trav360oor'), 'minecraft:observer', 'minecraft:unpowered_repeater',
                'minecraft:powered_repeater', 'minecraft:unpowered_comparator', 'minecraft:powered_comparator'
            ]
            const hasRedstonePower = Object.values(adjacentBlocks).some(adjacentBlock =>
                !excludedBlocks.includes(adjacentBlock?.typeId) && adjacentBlock?.getRedstonePower() > 0
            )
            const isRedstoneTorchTop = adjacentBlocks.above?.typeId === 'minecraft:redstone_torch' &&
                adjacentBlocks.above.permutation.getState('torch_facing_direction') === 'top'
            const destroyableBlocksArray = [
                block.typeId.includes('button'), block.typeId.includes('presure_plate')
            ]
            const destroyableBlocks = destroyableBlocksArray.includes(adjacentBlocks.above?.typeId) &&
                adjacentBlocks.above?.getRedstonePower() > 0
            const observerFacingBlock = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' },
                { block: adjacentBlocks.above, direction: 'up' },
                { block: adjacentBlocks.below, direction: 'down' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:observer' &&
                block?.permutation.getState('minecraft:facing_direction') === direction && block?.getRedstonePower() > 1)
            const poweredRepeater = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:powered_repeater' &&
                block?.permutation.getState('minecraft:cardinal_direction') === direction)
            const poweredComparator = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:powered_comparator' &&
                block?.permutation.getState('minecraft:cardinal_direction') === direction)
            const previousState = blockStates.get(blockKey) || false
            const shouldOpen = (hasRedstonePower || observerFacingBlock || poweredRepeater || poweredComparator) && !previousState && !isRedstoneTorchTop
            const shouldClose = (!hasRedstonePower && !observerFacingBlock && !poweredRepeater && !poweredComparator) && previousState && !isRedstoneTorchTop
            if (shouldOpen || shouldClose) {
                const newState = shouldOpen
                block.setPermutation(block.permutation.withState('v360:open', newState))
                block.dimension.playSound(sound, block.location)
                blockStates.set(blockKey, newState)
                if (adjacentBlocks.above.typeId === 'v360:araucaria_fence_gate' && adjacentBlocks.above.permutation.getState('v360:invisible')) {
                    adjacentBlocks.above.setPermutation(adjacentBlocks.above.permutation.withState('v360:open', newState))
                }
            }
            if (destroyableBlocks) {
                block.dimension.runCommand(`setblock ${x} ${y + 1} ${z} air destroy`)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:end_fence_gate', {
        onPlayerInteract(e) {
            const { block, player, face } = e
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            if (selectedItem && face === 'Up' && BlockTypes.get(selectedItem.typeId)) {
                const aboveBlock = block.above()
                if (aboveBlock.typeId === 'v360:end_fence_gate') {
                    aboveBlock.setType(selectedItem.typeId)
                    if (player.getGameMode() !== "creative") {
                        if (selectedItem.amount > 1) {
                            selectedItem.amount -= 1
                            equipment.setEquipment('Mainhand', selectedItem)
                        } else {
                            equipment.setEquipment('Mainhand', undefined)
                        }
                    }
                    return
                }
            }
            const currentState = block.permutation.getState('v360:open')
            const newOpenState = !currentState
            const sound = newOpenState ? 'open.fence_gate' : 'close.fence_gate'
            const rotationAngle = player.getRotation().y
            const newCardinalDirection = getNewCardinalDirection(block.permutation.getState('minecraft:cardinal_direction'), rotationAngle)
            const newPermutation = BlockPermutation.resolve(block.typeId, {
                ...block.permutation.getAllStates(),
                'v360:open': newOpenState,
                'minecraft:cardinal_direction': newCardinalDirection
            })
            block.setPermutation(newPermutation)
            block.dimension.playSound(sound, block.location)
            const aboveBlock = block.above()
            if (aboveBlock.typeId === 'v360:end_fence_gate' && aboveBlock.permutation.getState('v360:invisible')) {
                const aboveCurrentState = aboveBlock.permutation.getState('v360:open')
                if (aboveCurrentState !== newOpenState) {
                    const newAbovePermutation = BlockPermutation.resolve(aboveBlock.typeId, {
                        ...aboveBlock.permutation.getAllStates(),
                        'v360:open': newOpenState
                    });
                    aboveBlock.setPermutation(newAbovePermutation)
                }
            }
        },
        onPlayerDestroy(e) {
            const { block } = e
            const aboveBlock = block.above()
            if (aboveBlock.typeId === 'v360:end_fence_gate' && aboveBlock.permutation.getState('v360:invisible')) {
                aboveBlock.setType('minecraft:air')
            }
        },
        onPlace(e) {
            const { block } = e
            const aboveBlock = block.above()
            const currentStates = block.permutation.getAllStates()
            const cardinalDirection = currentStates['minecraft:cardinal_direction']
            if (cardinalDirection === 'south') {
                const newDirection = true
                currentStates['v360:direction'] = newDirection
                const newPermutation = BlockPermutation.resolve(block.typeId, currentStates)
                block.setPermutation(newPermutation);
            }
            if (aboveBlock.typeId === 'minecraft:air') {
                const newAboveStates = { ...currentStates }
                if (cardinalDirection === 'south') {
                    delete newAboveStates['minecraft:cardinal_direction']
                }
                newAboveStates['v360:invisible'] = true
                aboveBlock.setPermutation(BlockPermutation.resolve('v360:end_fence_gate', newAboveStates))
            }
        },
        onTick(e) {
            const { block } = e;
            const { x, y, z } = block.location;
            const blockKey = `${x},${y},${z}`;
            const currentState = block.permutation.getState('v360:open')
            const cardinalDirection = block.permutation.getState('minecraft:cardinal_direction')
            const sound = currentState ? 'open.fence_gate' : 'close.fence_gate'
            const adjacentBlocks = {
                north: block.north(),
                east: block.east(),
                south: block.south(),
                west: block.west(),
                above: block.above(),
                below: block.below()
            }
            const allowedBlocks = [block.typeId.includes('wall')]
            const hasAllowedBlock = (blocks) => blocks.some(adjacentBlock => allowedBlocks.includes(adjacentBlock?.typeId))
            const hasAllowedAdjacentBlock = (cardinalDirection === 'north' || cardinalDirection === 'south')
                ? hasAllowedBlock([adjacentBlocks.east, adjacentBlocks.west])
                : hasAllowedBlock([adjacentBlocks.north, adjacentBlocks.south])
            block.setPermutation(block.permutation.withState('v360:in_wall_bit', hasAllowedAdjacentBlock))
            const excludedBlocks = [
                block.typeId.includes('door'), block.typeId.includes('trav360oor'), 'minecraft:observer', 'minecraft:unpowered_repeater',
                'minecraft:powered_repeater', 'minecraft:unpowered_comparator', 'minecraft:powered_comparator'
            ]
            const hasRedstonePower = Object.values(adjacentBlocks).some(adjacentBlock =>
                !excludedBlocks.includes(adjacentBlock?.typeId) && adjacentBlock?.getRedstonePower() > 0
            )
            const isRedstoneTorchTop = adjacentBlocks.above?.typeId === 'minecraft:redstone_torch' &&
                adjacentBlocks.above.permutation.getState('torch_facing_direction') === 'top'
            const destroyableBlocksArray = [
                block.typeId.includes('button'), block.typeId.includes('presure_plate')
            ]
            const destroyableBlocks = destroyableBlocksArray.includes(adjacentBlocks.above?.typeId) &&
                adjacentBlocks.above?.getRedstonePower() > 0
            const observerFacingBlock = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' },
                { block: adjacentBlocks.above, direction: 'up' },
                { block: adjacentBlocks.below, direction: 'down' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:observer' &&
                block?.permutation.getState('minecraft:facing_direction') === direction && block?.getRedstonePower() > 1)
            const poweredRepeater = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:powered_repeater' &&
                block?.permutation.getState('minecraft:cardinal_direction') === direction)
            const poweredComparator = [
                { block: adjacentBlocks.north, direction: 'north' },
                { block: adjacentBlocks.east, direction: 'east' },
                { block: adjacentBlocks.south, direction: 'south' },
                { block: adjacentBlocks.west, direction: 'west' }
            ].some(({ block, direction }) => block?.typeId === 'minecraft:powered_comparator' &&
                block?.permutation.getState('minecraft:cardinal_direction') === direction)
            const previousState = blockStates.get(blockKey) || false
            const shouldOpen = (hasRedstonePower || observerFacingBlock || poweredRepeater || poweredComparator) && !previousState && !isRedstoneTorchTop
            const shouldClose = (!hasRedstonePower && !observerFacingBlock && !poweredRepeater && !poweredComparator) && previousState && !isRedstoneTorchTop
            if (shouldOpen || shouldClose) {
                const newState = shouldOpen
                block.setPermutation(block.permutation.withState('v360:open', newState))
                block.dimension.playSound(sound, block.location)
                blockStates.set(blockKey, newState)
                if (adjacentBlocks.above.typeId === 'v360:end_fence_gate' && adjacentBlocks.above.permutation.getState('v360:invisible')) {
                    adjacentBlocks.above.setPermutation(adjacentBlocks.above.permutation.withState('v360:open', newState))
                }
            }
            if (destroyableBlocks) {
                block.dimension.runCommand(`setblock ${x} ${y + 1} ${z} air destroy`)
            }
        }
    })
})

function getNewCardinalDirection(currentDirection, angle) {
    const direction = directionDisplay(angle);
    if (['north', 'south'].includes(currentDirection)) {
        return direction.includes('south') ? 'south' : 'north'
    } else {
        return direction.includes('west') ? 'west' : 'east'
    }
}

function directionDisplay(angle) {
    if (Math.abs(angle) > 112.5) return 'north'
    if (Math.abs(angle) < 67.5) return 'south'
    if (angle < 157.5 && angle > 22.5) return 'west'
    if (angle > -157.5 && angle < -22.5) return 'east'
    return '';
}

const blockStates = new Map()